<?php
/*
Plugin Name: KarnatakaBest Chatbot
Description: A simple chatbot plugin for Kannada + English with future ChatGPT support.
Version: 1.0
Author: Praveen Chandra Puttur
*/

add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('kb-chatbot-style', plugin_dir_url(__FILE__) . 'style.css');
    wp_enqueue_script('kb-chatbot-script', plugin_dir_url(__FILE__) . 'script.js', ['jquery'], null, true);
    wp_localize_script('kb-chatbot-script', 'kbChatbotAjax', ['ajaxurl' => admin_url('admin-ajax.php')]);
});

add_shortcode('karnatakabest_chatbot', function() {
    return '<div id="kb-chatbot-container">
        <div id="kb-chat-window">
            <div class="kb-chat-header">💬 KarnatakaBest Chatbot</div>
            <div id="kb-chat-messages"></div>
            <input type="text" id="kb-user-input" placeholder="Type your message...">
            <button id="kb-send-btn">Send</button>
        </div>
        <div id="kb-chat-toggle">💬</div>
    </div>';
});

add_action('wp_ajax_kb_chatbot_response', 'kb_chatbot_response');
add_action('wp_ajax_nopriv_kb_chatbot_response', 'kb_chatbot_response');
function kb_chatbot_response() {
    $input = strtolower(sanitize_text_field($_POST['message']));
    $response = '';

    if (strpos($input, 'web') !== false) {
        $response = 'ನಾವು ₹4,999 ದಿಂದ ವೆಬ್‌ಸೈಟ್ ವಿನ್ಯಾಸ ನೀಡುತ್ತೇವೆ. ಇಮೇಲ್ ಮಾಡಿ: support@karnatakabest.com';
    } elseif (strpos($input, 'seo') !== false) {
        $response = 'SEO ಸೇವೆಗಳು ₹3,999 ದಿಂದ ಪ್ರಾರಂಭವಾಗುತ್ತವೆ.';
    } elseif (strpos($input, 'blog') !== false) {
        $response = 'ಕನ್ನಡ ಮತ್ತು ಇಂಗ್ಲಿಷ್ ಬ್ಲಾಗ್ ಬರವಣಿಗೆ ಲಭ್ಯವಿದೆ.';
    } else {
        $response = 'ನಿಮ್ಮ ಪ್ರಶ್ನೆಯನ್ನು ಇನ್ನಷ್ಟು ಸ್ಪಷ್ಟವಾಗಿ ಕೇಳಿ. 😊';
    }

    wp_send_json_success(['response' => $response]);
}
