<?php
/*
Plugin Name: Karnatakabest Coming Soon
Description: Simple Coming Soon and Maintenance Mode plugin with logo, background image, countdown timer.
Version: 1.0
Author: Praveen Chandra Puttur
*/

require_once plugin_dir_path(__FILE__) . 'inc/functions.php';

function kcs_enqueue_styles() {
    if (!current_user_can('manage_options') && get_option('kcs_enabled') === 'yes') {
        wp_enqueue_style('kcs-style', plugin_dir_url(__FILE__) . 'style.css');
    }
}
add_action('wp_enqueue_scripts', 'kcs_enqueue_styles');

function kcs_coming_soon_template() {
    if (!current_user_can('manage_options') && get_option('kcs_enabled') === 'yes') {
        status_header(503);
        include plugin_dir_path(__FILE__) . 'template-coming-soon.php';
        exit();
    }
}
add_action('template_redirect', 'kcs_coming_soon_template');

function kcs_admin_menu() {
    add_options_page('Karnatakabest Coming Soon', 'Coming Soon Settings', 'manage_options', 'kcs-settings', 'kcs_settings_page');
}
add_action('admin_menu', 'kcs_admin_menu');

function kcs_admin_scripts($hook) {
    if ($hook !== 'settings_page_kcs-settings') return;
    wp_enqueue_media();
    wp_enqueue_script('kcs-admin-js', plugin_dir_url(__FILE__) . 'js/admin.js', array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'kcs_admin_scripts');

function kcs_settings_page() {
    if (isset($_POST['kcs_save'])) {
        update_option('kcs_enabled', $_POST['kcs_enabled']);
        update_option('kcs_message', sanitize_text_field($_POST['kcs_message']));
        update_option('kcs_countdown', sanitize_text_field($_POST['kcs_countdown']));
        if (!empty($_POST['kcs_logo'])) update_option('kcs_logo', $_POST['kcs_logo']);
        if (!empty($_POST['kcs_bg_image'])) update_option('kcs_bg_image', $_POST['kcs_bg_image']);
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }
    $enabled = get_option('kcs_enabled', 'no');
    $message = get_option('kcs_message', 'We are coming soon!');
    $countdown = get_option('kcs_countdown');
    $logo = get_option('kcs_logo');
    $bg_image = get_option('kcs_bg_image');
    ?>
    <div class="wrap">
        <h1>Karnatakabest Coming Soon Settings</h1>
        <form method="post">
            <table class="form-table">
                <tr><th>Enable Mode</th><td><input type="checkbox" name="kcs_enabled" value="yes" <?php checked($enabled, 'yes'); ?>></td></tr>
                <tr><th>Message</th><td><input type="text" name="kcs_message" value="<?php echo esc_attr($message); ?>" size="50"></td></tr>
                <tr><th>Countdown</th><td><input type="datetime-local" name="kcs_countdown" value="<?php echo esc_attr($countdown); ?>"></td></tr>
                <tr><th>Logo</th><td><input type="hidden" name="kcs_logo" id="kcs_logo" value="<?php echo esc_attr($logo); ?>">
                    <button type="button" class="button" id="upload_logo">Upload Logo</button>
                </td></tr>
                <tr><th>Background</th><td><input type="hidden" name="kcs_bg_image" id="kcs_bg_image" value="<?php echo esc_attr($bg_image); ?>">
                    <button type="button" class="button" id="upload_bg">Upload Background</button>
                </td></tr>
            </table>
            <p><input type="submit" name="kcs_save" class="button button-primary" value="Save Settings"></p>
        </form>
    </div>
    <?php
}
