<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Coming Soon</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__); ?>style.css">
</head>
<body style="background-image: url('<?php echo esc_url(kcs_get_bg_image_url()); ?>');">
    <div class="kcs-container">
        <?php if ($logo = kcs_get_logo_url()): ?>
            <img src="<?php echo esc_url($logo); ?>" alt="Logo" style="max-height: 120px;">
        <?php endif; ?>
        <h1><?php echo esc_html(get_option('kcs_message', 'We are coming soon!')); ?></h1>
        <?php if ($target = get_option('kcs_countdown')): ?>
            <div id="kcs-timer"></div>
            <script>
                const countdownDate = new Date("<?php echo esc_js($target); ?>").getTime();
                const timerInterval = setInterval(() => {
                    const now = new Date().getTime();
                    const distance = countdownDate - now;
                    if (distance < 0) {
                        clearInterval(timerInterval);
                        document.getElementById("kcs-timer").innerHTML = "Launching Soon!";
                        return;
                    }
                    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);
                    document.getElementById("kcs-timer").innerHTML = 
                        days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
                }, 1000);
            </script>
        <?php endif; ?>
        <footer><p>Plugin Developed by: <a href="https://karnatakabest.com" target="_blank">Karnatakabest.com</a></p></footer>
    </div>
</body>
</html>
